<!DOCTYPE html>
<html lang="en">

<head>

    <title>Sorteo Peninsula</title>
    <link rel="shortcut icon" href="{{ asset('front/images/logo.png') }}" type="image/ico" />

    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

    <link rel="stylesheet" href="{{ asset('front/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('front/css/font-awesome.min.css') }}">
    <link rel="stylesheet" href="{{ asset('front/css/aos.css') }}">

    <!-- MAIN CSS -->
    <link rel="stylesheet" href="{{ asset('front/css/tooplate-gymso-style.css') }}">
    <!--
Tooplate 2119 Gymso Fitness
https://www.tooplate.com/view/2119-gymso-fitness
-->
</head>

<body data-spy="scroll" data-target="#navbarNav" data-offset="50">

    <!-- MENU BAR -->
    <nav class="navbar navbar-expand-lg fixed-top">
        <div class="container">

            <a class="navbar-brand" href="index.html">
                <img src="{{ asset('front/images/logo.png') }}" alt="" width="50">
                Sorteo Peninsula</a>

            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav"
                aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ml-lg-auto">
                    <li class="nav-item">
                        <a href="#home" class="nav-link smoothScroll">INICIO</a>
                    </li>

                    <li class="nav-item">
                        <a href="#informaciones" class="nav-link smoothScroll">Informaciones</a>
                    </li>

                    <li class="nav-item">
                        <a href="#nosotros" class="nav-link smoothScroll">Nosotros</a>
                    </li>

                    <li class="nav-item">
                        <a href="#contacto" class="nav-link smoothScroll">Contacto</a>
                    </li>

                    <li class="nav-item">
                        <a href="#feature" class="nav-link smoothScroll">Comprar Boletos</a>
                    </li>
                </ul>


            </div>

        </div>
    </nav>


    @yield('contanido')


    <!-- FOOTER -->
    <footer class="site-footer">
        <div class="container">
            <div class="row">

                <div class="ml-auto col-lg-4 col-md-5">
                    <p class="copyright-text">Copyright &copy; 2020 Sorteo Peninsula.
                    </p>
                </div>

                <div class="d-flex justify-content-center mx-auto col-lg-5 col-md-7 col-12">
                    <p class="mr-2">
                        <i class="fa fa-envelope-o mr-1"></i>
                        <a href="mailto:sportgearmx23@gmail.com">sportgearmx23@gmail</a>
                    </p>

                    <p><i class="fa fa-phone mr-1"></i> <a
                            href="tel:sportgearmx23@gmail.com">2020202</a></p>
                </div>

            </div>
        </div>
    </footer>

    <!-- Modal -->
    <div class="modal fade" id="membershipForm" tabindex="-1" role="dialog" aria-labelledby="membershipFormLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 class="modal-title" id="membershipFormLabel">Enviar Numero</h2>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form class="membership-form webform" role="form" action="{{ url('/enviar_numeros') }}"
                        method="POST">
                        @csrf
                        <label for="">Nombre</label>
                        <input style="margin: 2px;" type="text" class="form-control" name="nombre"
                            placeholder="Ej:Juan" required>
                        <label for="">Apellido</label>
                        <input style="margin: 2px;" type="text" class="form-control" name="apellido"
                            placeholder="Ej:Gonzales" required>
                        <label for="">Localidad</label>
                        <select style="margin: 2px;" name="localidad" class="form-control" required>
                            <option value="">SELECCIONA ESTADO</option>
                            <option value="ESTADOS UNIDOS">ESTADOS UNIDOS</option>
                            <option value="OTRO PAIS">OTRO PAIS</option>
                            <option value="AGUASCALIENTES">AGUASCALIENTES</option>
                            <option value="BAJA CALIFORNIA">BAJA CALIFORNIA</option>
                            <option value="BAJA CALIFORNIA SUR">BAJA CALIFORNIA SUR</option>
                            <option value="CAMPECHE">CAMPECHE</option>
                            <option value="CIUDAD DE MÉXICO">CIUDAD DE MÉXICO</option>
                            <option value="COAHUILA">COAHUILA</option>
                            <option value="COLIMA">COLIMA</option>
                            <option value="CHIAPAS">CHIAPAS</option>
                            <option value="CHIHUAHUA">CHIHUAHUA</option>
                            <option value="DURANGO">DURANGO</option>
                            <option value="ESTADO DE MÉXICO">ESTADO DE MÉXICO</option>
                            <option value="GUANAJUATO">GUANAJUATO</option>
                            <option value="GUERRERO">GUERRERO</option>
                            <option value="HIDALGO">HIDALGO</option>
                            <option value="JALISCO">JALISCO</option>
                            <option value="MICHOACÁN">MICHOACÁN</option>
                            <option value="MORELOS">MORELOS</option>
                            <option value="NAYARIT">NAYARIT</option>
                            <option value="NUEVO LEÓN">NUEVO LEÓN</option>
                            <option value="OAXACA">OAXACA</option>
                            <option value="PUEBLA">PUEBLA</option>
                            <option value="QUERÉTARO">QUERÉTARO</option>
                            <option value="QUINTANA ROO">QUINTANA ROO</option>
                            <option value="SAN LUIS POTOSÍ">SAN LUIS POTOSÍ</option>
                            <option value="SINALOA">SINALOA</option>
                            <option value="SONORA">SONORA</option>
                            <option value="TABASCO">TABASCO</option>
                            <option value="TAMAULIPAS">TAMAULIPAS</option>
                            <option value="TLAXCALA">TLAXCALA</option>
                            <option value="VERACRUZ">VERACRUZ</option>
                            <option value="YUCATÁN">YUCATÁN</option>
                            <option value="ZACATECAS">ZACATECAS</option>
                        </select>
                        <label for="">Telefono</label>
                        <input style="margin: 2px;" type="tel" class="form-control" name="telefono"
                            placeholder="123-456-7890" required>
                        <div id="numeros_modal">

                        </div>
                        <button type="submit" class="form-control" id="submit-button" name="submit">
                            Enviar</button>

                    </form>
                </div>
                <div class="modal-footer"></div>
            </div>
        </div>
    </div>

    <!-- SCRIPTS -->
    <script src="{{ asset('front/js/jquery.min.js') }}"></script>
    <script src="{{ asset('front/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('front/js/aos.js') }}"></script>
    <script src="{{ asset('front/js/smoothscroll.js') }}"></script>
    <script src="{{ asset('front/js/custom.js') }}"></script>
    <link href="//cdn.jsdelivr.net/npm/@sweetalert2/theme-dark@4/dark.css" rel="stylesheet">
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.js"></script>
    <script>
        const numeros_seleccionados = [];
        var numeros_ocupados = [];
        var numeros_arr = [];

        function buscar_numero(numero) {
            console.log(numeros_ocupados);
            if (numeros_ocupados.find(valor => valor.numero == numero) == null) {
                document.getElementById('div_resultado_buscar').innerHTML = `
                <span class="btn custom-btn bordered mt-3 aos-init aos-animate" id="bus_${numero}"  style="padding: 10px;margin: 10px; border: 1px solid; border-radius: 80px;">${numero}</span>
                <span style="color:white">Disponible </span>
                <span style="color:#20ff00" onclick="seleccionar_numero_busqueda(${numero})">| Agregar</span>
                <hr>
                `;
            } else {
                document.getElementById('div_resultado_buscar').innerHTML = `
                <span class="btn custom-btn bordered mt-3 aos-init aos-animate"   style="padding: 10px;margin: 10px; border: 1px solid; border-radius: 80px;">${numero}</span>
                <span style="color:red">No Disponible</span>
                <hr>
                `;
            }
        }

        function mostrar_modal() {
            var div_modal = document.getElementById('numeros_modal');
            div_modal.innerHTML = '';
            $('#membershipForm').modal('show');
            console.log(numeros_seleccionados);
            numeros_seleccionados.forEach(element => div_modal.innerHTML += `
              <span class="btn custom-btn bordered mt-3 " onclick="seleccionar_numero(${element});mostrar_modal()" style="padding: 10px;margin: 10px; border: 1px solid; border-radius: 80px;">${element}</span>
              <input type="hidden" name="numeros[]" value="${element}">
              `);


        }

        function seleccionar_numero_busqueda(numero) {
            if (numeros_seleccionados.indexOf(numero) == -1 && (numeros_arr.indexOf(numero) == -1)) {
                numeros_seleccionados.push(numero);
                document.getElementById('div_select_buscar').innerHTML +=
                    `
                <span class="btn custom-btn bordered mt-3 aos-init aos-animate" onclick="seleccionar_numero(${numero})" id='num_${numero}' style="padding: 10px;margin: 10px; border: 1px solid; border-radius: 80px;">${numero}</span>`;
            } else {
                numeros_seleccionados.splice(numeros_seleccionados.indexOf(numero), 1);
            }
            var span_num = document.getElementById('num_' + numero);
            if (span_num.style.background == '') {
                span_num.style.background = 'white';

            } else {
                white
                span_num.style.background = '';

            }

        }

        function seleccionar_numero(numero) {
            if (numeros_seleccionados.indexOf(numero) == -1) {
                numeros_seleccionados.push(numero);
            } else {
                numeros_seleccionados.splice(numeros_seleccionados.indexOf(numero), 1);
            }
            var span_num = document.getElementById('num_' + numero);
            if (span_num.style.background == 'white') {
                span_num.style.background = '';
            } else {
                span_num.style.background = 'white';
            }
        }

        function getRandomInt(min, max) {
            min = Math.ceil(min);
            max = Math.floor(max);
            return Math.floor(Math.random() * (max - min + 1)) + min;
        }

        function cargar_numeros_ocupados(url) {
            document.getElementById('div_numeros').innerHTML = `<center><div class="spinner-grow" role="status">
                  <span class="sr-only">Cargando...</span>
                   </div>
                   </center>
                             `;
            fetch('api/numeros', {
                    headers: {
                        'X-CSRF-TOKEN': window.CSRF_TOKEN,
                        'content-type': 'application/json'
                    },
                    method: "GET"
                })
                .then(r => r.json())
                .then(respuesta => {
                    var div_numeros = document.getElementById('div_numeros');
                    numeros_arr = [];
                    var cant_numeros = 50;
                    if (respuesta.data.length > 3050) {
                        cant_numeros = 4000 - respuesta.data.length;
                    }
                    for (let index = 0; index < cant_numeros; index++) {
                        var temp = getRandomInt(1, 4000)
                        if ((respuesta.data.find(numero => numero.numero === temp) == null) && (numeros_arr.indexOf(
                                temp) == -1)) {
                            numeros_arr.push(temp);
                        } else {
                            index--;
                        }
                    }
                    div_numeros.innerHTML = '';
                    numeros_ocupados = respuesta.data;
                    numeros_arr.forEach(element => div_numeros.innerHTML += `
              <span class="btn custom-btn bordered mt-3 aos-init aos-animate" onclick="seleccionar_numero(${element})" id='num_${element}' style="padding: 10px;margin: 10px; border: 1px solid; border-radius: 80px;">${element}</span>
              `);


                }).catch((error) => {
                    //console.error('Error:', error);
                    document.getElementById('div_numeros').innerHTML =
                        '<center><h3>Ha ocurrido un error al cargar los datos</h3></center>'
                });;
        }
        $(document).ready(function() {
            @if (session('datos_apartado'))
                Swal.fire({
                    position: 'top-end',
                    icon: 'success',
                    title: 'Sus numeros han sido almacenados, sera redirigido a whatsapp para enviar la informacion',
                    showConfirmButton: false,
                    timer: 1500
                });
                setTimeout(() => {
                    var datos = @php echo json_encode(session('datos_apartado')); @endphp;
                    console.log(datos);
                    location.href =
                        "https://api.whatsapp.com/send/?phone=%+5354557125&text=Hola%2C+Aparte+boletos+de+la+rifa------------------------>" +
                        datos.numeros.length + "-Boletos=>" + datos.numeros;
                }, 2000);
            @endif
            @if (session('msg'))
                Swal.fire({
                    position: 'top-end',
                    icon: 'success',
                    title: '{{ session('msg') }}',
                    showConfirmButton: false,
                    timer: 1500
                });
            @endif
            @if (session('error'))
                Swal.fire({
                    position: 'top-end',
                    icon: 'error',
                    title: '{{ session('error') }}',
                    showConfirmButton: false,
                    timer: 1500
                });
            @endif
            cargar_numeros_ocupados();
        });
    </script>

</body>

</html>
